package net.w_horse.excelpojo.excel;

import static org.junit.Assert.*;

import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;

import net.w_horse.excelpojo.AbstractTest;
import net.w_horse.excelpojo.ExcelPOJOException;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Test;
import org.springframework.beans.TypeMismatchException;

public class ExcelUtilsTest extends AbstractTest {

	@Test
	public void testDataFormat() throws ExcelPOJOException, IOException {
		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/upload/ParserTest.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("eZ^Cv");

			assertEquals("eZ^Cv 01", new Integer(1), ExcelUtils.getCellValue(getCell(sheet, 1, 2), int.class));
			assertEquals("eZ^Cv 01String", "1", ExcelUtils.getCellValue(getCell(sheet, 1, 2), String.class));
			assertEquals("eZ^Cv 01double", 1.0, ExcelUtils.getCellValue(getCell(sheet, 1, 2), double.class), 0.1);
			assertEquals("eZ^Cv 01BigDecimal", new BigDecimal("1"), ExcelUtils.getCellValue(getCell(sheet, 1, 2), BigDecimal.class));

			assertEquals("eZ^Cv 02", "", ExcelUtils.getCellValue(getCell(sheet, 2, 2), String.class));

			assertEquals("eZ^Cv 03", new Integer(-1234), ExcelUtils.getCellValue(getCell(sheet, 3, 2), int.class));
			assertEquals("eZ^Cv 03String", "(1,234)", ExcelUtils.getCellValue(getCell(sheet, 3, 2), String.class));
			assertEquals("eZ^Cv 03double", -1234.0, ExcelUtils.getCellValue(getCell(sheet, 3, 2), double.class), 0.1);
			assertEquals("eZ^Cv 03BigDecimal", new BigDecimal("-1234"), ExcelUtils.getCellValue(getCell(sheet, 3, 2), BigDecimal.class));

			assertEquals("eZ^Cv 04", new Integer(-1234), ExcelUtils.getCellValue(getCell(sheet, 4, 2), int.class));
			assertEquals("eZ^Cv 04String", "(1,234)", ExcelUtils.getCellValue(getCell(sheet, 4, 2), String.class));
			assertEquals("eZ^Cv 04double", -1234.0, ExcelUtils.getCellValue(getCell(sheet, 4, 2), double.class), 0.1);
			assertEquals("eZ^Cv 04BigDecimal", new BigDecimal("-1234"), ExcelUtils.getCellValue(getCell(sheet, 4, 2), BigDecimal.class));

			assertEquals("eZ^Cv 05", new Integer(-1234), ExcelUtils.getCellValue(getCell(sheet, 5, 2), int.class));
			assertEquals("eZ^Cv 05String", "-1,234", ExcelUtils.getCellValue(getCell(sheet, 5, 2), String.class));
			assertEquals("eZ^Cv 05double", -1234.0, ExcelUtils.getCellValue(getCell(sheet, 5, 2), double.class), 0.1);
			assertEquals("eZ^Cv 05BigDecimal", new BigDecimal("-1234"), ExcelUtils.getCellValue(getCell(sheet, 5, 2), BigDecimal.class));

			assertEquals("eZ^Cv 06", new Integer(-1234), ExcelUtils.getCellValue(getCell(sheet, 6, 2), int.class));
			assertEquals("eZ^Cv 06String", "-1,234", ExcelUtils.getCellValue(getCell(sheet, 6, 2), String.class));
			assertEquals("eZ^Cv 06double", -1234.0, ExcelUtils.getCellValue(getCell(sheet, 6, 2), double.class), 0.1);
			assertEquals("eZ^Cv 06BigDecimal", new BigDecimal("-1234"), ExcelUtils.getCellValue(getCell(sheet, 6, 2), BigDecimal.class));

			assertEquals("eZ^Cv 07", new Integer(-1234), ExcelUtils.getCellValue(getCell(sheet, 7, 2), int.class));
			assertEquals("eZ^Cv 07String", "-1,234", ExcelUtils.getCellValue(getCell(sheet, 7, 2), String.class));
			assertEquals("eZ^Cv 07double", -1234.0, ExcelUtils.getCellValue(getCell(sheet, 7, 2), double.class), 0.1);
			assertEquals("eZ^Cv 07BigDecimal", new BigDecimal("-1234"), ExcelUtils.getCellValue(getCell(sheet, 7, 2), BigDecimal.class));

			assertEquals("eZ^Cv 08", new Integer(-1234), ExcelUtils.getCellValue(getCell(sheet, 8, 2), int.class));
			assertEquals("eZ^Cv 08String", " 1,234", ExcelUtils.getCellValue(getCell(sheet, 8, 2), String.class));
			assertEquals("eZ^Cv 08double", -1234.0, ExcelUtils.getCellValue(getCell(sheet, 8, 2), double.class), 0.1);
			assertEquals("eZ^Cv 08BigDecimal", new BigDecimal("-1234"), ExcelUtils.getCellValue(getCell(sheet, 8, 2), BigDecimal.class));

			assertEquals("eZ^Cv 09", new Integer(-1234), ExcelUtils.getCellValue(getCell(sheet, 9, 2), int.class));
			assertEquals("eZ^Cv 09String", " 1,234", ExcelUtils.getCellValue(getCell(sheet, 9, 2), String.class));
			assertEquals("eZ^Cv 09double", -1234.0, ExcelUtils.getCellValue(getCell(sheet, 9, 2), double.class), 0.1);
			assertEquals("eZ^Cv 09BigDecimal", new BigDecimal("-1234"), ExcelUtils.getCellValue(getCell(sheet, 9, 2), BigDecimal.class));

			assertEquals("eZ^Cv 10", -1234.56, ExcelUtils.getCellValue(getCell(sheet, 10, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 10String", "(1234.56)", ExcelUtils.getCellValue(getCell(sheet, 10, 2), String.class));
			assertEquals("eZ^Cv 10double", -1234.56, ExcelUtils.getCellValue(getCell(sheet, 10, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 10BigDecimal", new BigDecimal("-1234.56"), ExcelUtils.getCellValue(getCell(sheet, 10, 2), BigDecimal.class));

			assertEquals("eZ^Cv 11", -1234.56, ExcelUtils.getCellValue(getCell(sheet, 11, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 11String", "(1234.56)", ExcelUtils.getCellValue(getCell(sheet, 11, 2), String.class));
			assertEquals("eZ^Cv 11double", -1234.56, ExcelUtils.getCellValue(getCell(sheet, 11, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 11BigDecimal", new BigDecimal("-1234.56"), ExcelUtils.getCellValue(getCell(sheet, 11, 2), BigDecimal.class));

			assertEquals("eZ^Cv 12", -1234.56, ExcelUtils.getCellValue(getCell(sheet, 12, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 12String", "-1234.56", ExcelUtils.getCellValue(getCell(sheet, 12, 2), String.class));
			assertEquals("eZ^Cv 12double", -1234.56, ExcelUtils.getCellValue(getCell(sheet, 12, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 12BigDecimal", new BigDecimal("-1234.56"), ExcelUtils.getCellValue(getCell(sheet, 12, 2), BigDecimal.class));

			assertEquals("eZ^Cv 13", -1234.56, ExcelUtils.getCellValue(getCell(sheet, 13, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 13String", "-1234.56", ExcelUtils.getCellValue(getCell(sheet, 13, 2), String.class));
			assertEquals("eZ^Cv 13double", -1234.56, ExcelUtils.getCellValue(getCell(sheet, 13, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 13BigDecimal", new BigDecimal("-1234.56"), ExcelUtils.getCellValue(getCell(sheet, 13, 2), BigDecimal.class));

			assertEquals("eZ^Cv 14", -1234.56, ExcelUtils.getCellValue(getCell(sheet, 14, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 14String", "-1234.56", ExcelUtils.getCellValue(getCell(sheet, 14, 2), String.class));
			assertEquals("eZ^Cv 14double", -1234.56, ExcelUtils.getCellValue(getCell(sheet, 14, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 14BigDecimal", new BigDecimal("-1234.56"), ExcelUtils.getCellValue(getCell(sheet, 14, 2), BigDecimal.class));

			assertEquals("eZ^Cv 15", -1234.56, ExcelUtils.getCellValue(getCell(sheet, 15, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 15String", " 1234.56", ExcelUtils.getCellValue(getCell(sheet, 15, 2), String.class));
			assertEquals("eZ^Cv 15double", -1234.56, ExcelUtils.getCellValue(getCell(sheet, 15, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 15BigDecimal", new BigDecimal("-1234.56"), ExcelUtils.getCellValue(getCell(sheet, 15, 2), BigDecimal.class));

			assertEquals("eZ^Cv 16", -1234.56, ExcelUtils.getCellValue(getCell(sheet, 16, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 16String", " 1234.56", ExcelUtils.getCellValue(getCell(sheet, 16, 2), String.class));
			assertEquals("eZ^Cv 16double", -1234.56, ExcelUtils.getCellValue(getCell(sheet, 16, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 16BigDecimal", new BigDecimal("-1234.56"), ExcelUtils.getCellValue(getCell(sheet, 16, 2), BigDecimal.class));

			assertEquals("eZ^Cv 17", new Integer(-123456), ExcelUtils.getCellValue(getCell(sheet, 17, 2), int.class));
			assertEquals("eZ^Cv 17String", "(123,456)", ExcelUtils.getCellValue(getCell(sheet, 17, 2), String.class));
			assertEquals("eZ^Cv 17double", -123456.0, ExcelUtils.getCellValue(getCell(sheet, 17, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 17BigDecimal", new BigDecimal("-123456"), ExcelUtils.getCellValue(getCell(sheet, 17, 2), BigDecimal.class));

			assertEquals("eZ^Cv 18", new Integer(-123456), ExcelUtils.getCellValue(getCell(sheet, 18, 2), int.class));
			assertEquals("eZ^Cv 18String", "(123,456)", ExcelUtils.getCellValue(getCell(sheet, 18, 2), String.class));
			assertEquals("eZ^Cv 18double", -123456.0, ExcelUtils.getCellValue(getCell(sheet, 18, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 18BigDecimal", new BigDecimal("-123456"), ExcelUtils.getCellValue(getCell(sheet, 18, 2), BigDecimal.class));

			assertEquals("eZ^Cv 19", new Integer(-123456), ExcelUtils.getCellValue(getCell(sheet, 19, 2), int.class));
			assertEquals("eZ^Cv 19String", "-123,456", ExcelUtils.getCellValue(getCell(sheet, 19, 2), String.class));
			assertEquals("eZ^Cv 19double", -123456.0, ExcelUtils.getCellValue(getCell(sheet, 19, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 19BigDecimal", new BigDecimal("-123456"), ExcelUtils.getCellValue(getCell(sheet, 19, 2), BigDecimal.class));

			assertEquals("eZ^Cv 20", new Integer(-123456), ExcelUtils.getCellValue(getCell(sheet, 20, 2), int.class));
			assertEquals("eZ^Cv 20String", "($123,456)", ExcelUtils.getCellValue(getCell(sheet, 20, 2), String.class));
			assertEquals("eZ^Cv 20double", -123456.0, ExcelUtils.getCellValue(getCell(sheet, 20, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 20BigDecimal", new BigDecimal("-123456"), ExcelUtils.getCellValue(getCell(sheet, 20, 2), BigDecimal.class));

			assertEquals("eZ^Cv 21", new Integer(-123456), ExcelUtils.getCellValue(getCell(sheet, 21, 2), int.class));
			assertEquals("eZ^Cv 21String", "($123,456)", ExcelUtils.getCellValue(getCell(sheet, 21, 2), String.class));
			assertEquals("eZ^Cv 21double", -123456.0, ExcelUtils.getCellValue(getCell(sheet, 21, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 21BigDecimal", new BigDecimal("-123456"), ExcelUtils.getCellValue(getCell(sheet, 21, 2), BigDecimal.class));

			assertEquals("eZ^Cv 22", -123456.78, ExcelUtils.getCellValue(getCell(sheet, 22, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 22String", "(123,456.78)", ExcelUtils.getCellValue(getCell(sheet, 22, 2), String.class));
			assertEquals("eZ^Cv 22double", -123456.78, ExcelUtils.getCellValue(getCell(sheet, 22, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 22BigDecimal", new BigDecimal("-123456.78"), ExcelUtils.getCellValue(getCell(sheet, 22, 2), BigDecimal.class));

			assertEquals("eZ^Cv 23", -123456.78, ExcelUtils.getCellValue(getCell(sheet, 23, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 23String", "(123,456.78)", ExcelUtils.getCellValue(getCell(sheet, 23, 2), String.class));
			assertEquals("eZ^Cv 23double", -123456.78, ExcelUtils.getCellValue(getCell(sheet, 23, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 23BigDecimal", new BigDecimal("-123456.78"), ExcelUtils.getCellValue(getCell(sheet, 23, 2), BigDecimal.class));

			assertEquals("eZ^Cv 24", -123456.78, ExcelUtils.getCellValue(getCell(sheet, 24, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 24String", "-123,456.78", ExcelUtils.getCellValue(getCell(sheet, 24, 2), String.class));
			assertEquals("eZ^Cv 24double", -123456.78, ExcelUtils.getCellValue(getCell(sheet, 24, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 24BigDecimal", new BigDecimal("-123456.78"), ExcelUtils.getCellValue(getCell(sheet, 24, 2), BigDecimal.class));

			assertEquals("eZ^Cv 25", -123456.78, ExcelUtils.getCellValue(getCell(sheet, 25, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 25String", "($123,456.78)", ExcelUtils.getCellValue(getCell(sheet, 25, 2), String.class));
			assertEquals("eZ^Cv 25double", -123456.78, ExcelUtils.getCellValue(getCell(sheet, 25, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 25BigDecimal", new BigDecimal("-123456.78"), ExcelUtils.getCellValue(getCell(sheet, 25, 2), BigDecimal.class));

			assertEquals("eZ^Cv 26", -123456.78, ExcelUtils.getCellValue(getCell(sheet, 26, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 26String", "($123,456.78)", ExcelUtils.getCellValue(getCell(sheet, 26, 2), String.class));
			assertEquals("eZ^Cv 26double", -123456.78, ExcelUtils.getCellValue(getCell(sheet, 26, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 26BigDecimal", new BigDecimal("-123456.78"), ExcelUtils.getCellValue(getCell(sheet, 26, 2), BigDecimal.class));

			assertEquals("eZ^Cv 27", new Integer(-123456), ExcelUtils.getCellValue(getCell(sheet, 27, 2), int.class));
			assertEquals("eZ^Cv 27String", "-123456", ExcelUtils.getCellValue(getCell(sheet, 27, 2), String.class));
			assertEquals("eZ^Cv 27double", -123456.00, ExcelUtils.getCellValue(getCell(sheet, 27, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 27BigDecimal", new BigDecimal("-123456"), ExcelUtils.getCellValue(getCell(sheet, 27, 2), BigDecimal.class));

			assertEquals("eZ^Cv 28", new Integer(-123456), ExcelUtils.getCellValue(getCell(sheet, 28, 2), int.class));
			assertEquals("eZ^Cv 28String", "-123456", ExcelUtils.getCellValue(getCell(sheet, 28, 2), String.class));
			assertEquals("eZ^Cv 28double", -123456.00, ExcelUtils.getCellValue(getCell(sheet, 28, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 28BigDecimal", new BigDecimal("-123456"), ExcelUtils.getCellValue(getCell(sheet, 28, 2), BigDecimal.class));

			assertEquals("eZ^Cv 29", -123456.78, ExcelUtils.getCellValue(getCell(sheet, 29, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 29String", "-123456.78", ExcelUtils.getCellValue(getCell(sheet, 29, 2), String.class));
			assertEquals("eZ^Cv 29double", -123456.78, ExcelUtils.getCellValue(getCell(sheet, 29, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 29BigDecimal", new BigDecimal("-123456.78"), ExcelUtils.getCellValue(getCell(sheet, 29, 2), BigDecimal.class));

			assertEquals("eZ^Cv 30", -123456.78, ExcelUtils.getCellValue(getCell(sheet, 30, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 30String", "-123456.78", ExcelUtils.getCellValue(getCell(sheet, 30, 2), String.class));
			assertEquals("eZ^Cv 30double", -123456.78, ExcelUtils.getCellValue(getCell(sheet, 30, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 30BigDecimal", new BigDecimal("-123456.78"), ExcelUtils.getCellValue(getCell(sheet, 30, 2), BigDecimal.class));

			assertEquals("eZ^Cv 31", 0.1234, ExcelUtils.getCellValue(getCell(sheet, 31, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 31String", "12%", ExcelUtils.getCellValue(getCell(sheet, 31, 2), String.class));
			assertEquals("eZ^Cv 31double", 0.1234, ExcelUtils.getCellValue(getCell(sheet, 31, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 31BigDecimal", new BigDecimal("0.1234"), ExcelUtils.getCellValue(getCell(sheet, 31, 2), BigDecimal.class));

			assertEquals("eZ^Cv 32", 0.1234, ExcelUtils.getCellValue(getCell(sheet, 32, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 32String", "12.34%", ExcelUtils.getCellValue(getCell(sheet, 32, 2), String.class));
			assertEquals("eZ^Cv 32double", 0.1234, ExcelUtils.getCellValue(getCell(sheet, 32, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 32BigDecimal", new BigDecimal("0.1234"), ExcelUtils.getCellValue(getCell(sheet, 32, 2), BigDecimal.class));

			assertEquals("eZ^Cv 33", new Integer(2), ExcelUtils.getCellValue(getCell(sheet, 33, 2), int.class));
			assertEquals("eZ^Cv 33String", "2", ExcelUtils.getCellValue(getCell(sheet, 33, 2), String.class));
			assertEquals("eZ^Cv 33double", 2, ExcelUtils.getCellValue(getCell(sheet, 33, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 33BigDecimal", new BigDecimal("2"), ExcelUtils.getCellValue(getCell(sheet, 33, 2), BigDecimal.class));

			assertEquals("eZ^Cv 34","_t", ExcelUtils.getCellValue(getCell(sheet, 34, 2), String.class));

			assertEquals("eZ^Cv 35", new Integer(-1234), ExcelUtils.getCellValue(getCell(sheet, 35, 2), int.class));
			assertEquals("eZ^Cv 35String", "-1234", ExcelUtils.getCellValue(getCell(sheet, 35, 2), String.class));
			assertEquals("eZ^Cv 35double", -1234.0, ExcelUtils.getCellValue(getCell(sheet, 35, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 35BigDecimal", new BigDecimal("-1234"), ExcelUtils.getCellValue(getCell(sheet, 35, 2), BigDecimal.class));

			assertEquals("eZ^Cv 36",(new GregorianCalendar(2010, 6 -1, 23)).getTime(), ExcelUtils.getCellValue(getCell(sheet, 36, 2), Date.class));
			assertEquals("eZ^Cv 36","2010N623", ExcelUtils.getCellValue(getCell(sheet, 36, 2), String.class));

			assertEquals("eZ^Cv 37",new BigInteger("-12345678901234500000"), ExcelUtils.getCellValue(getCell(sheet, 37, 2), BigInteger.class));
			assertEquals("eZ^Cv 37String", " 12,345,678,901,234,500,000", ExcelUtils.getCellValue(getCell(sheet, 37, 2), String.class));

			assertEquals("eZ^Cv 38",-1.23456789012345E12, ExcelUtils.getCellValue(getCell(sheet, 38, 2), double.class), 0.000000000000001);
			assertEquals("eZ^Cv 38String", " 1,234,567,890,123.45", ExcelUtils.getCellValue(getCell(sheet, 38, 2), String.class));

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	@Test
	public void testNUmeric() throws ExcelPOJOException, IOException {
		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/upload/ParserTest.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("liEj");

			assertEquals("liEj Integer.MIN_VALUE", new Integer(2147483647), ExcelUtils.getCellValue(getCell(sheet, 1, 2), int.class));
			assertEquals("liEj Integer.MAXV_ALUE", new Integer(-2147483648) , ExcelUtils.getCellValue(getCell(sheet, 2, 2), int.class));
			assertEquals("liEj Integer.MIN_VALUE +1", new BigInteger("2147483648"), ExcelUtils.getCellValue(getCell(sheet, 3, 2), BigInteger.class));
			assertEquals("liEj Integer.MAXV_ALUE -1", new BigInteger("-2147483649"), ExcelUtils.getCellValue(getCell(sheet, 4, 2), BigInteger.class));
			assertEquals("liEj Integer.MIN_VALUE", new BigInteger("2147483647"), ExcelUtils.getCellValue(getCell(sheet, 1, 2), BigInteger.class));
			assertEquals("liEj Integer.MAXV_ALUE", new BigInteger("-2147483648") , ExcelUtils.getCellValue(getCell(sheet, 2, 2), BigInteger.class));
			assertEquals("liEj ", 123.45, ExcelUtils.getCellValue(getCell(sheet, 5, 2), double.class), 0.000000000000001);
			assertEquals("liEj double ", 1.23456789012345, ExcelUtils.getCellValue(getCell(sheet, 6, 2), double.class), 0.000000000000001);
			assertEquals("liEj double ŏ", 2.2250738585072014E-308, ExcelUtils.getCellValue(getCell(sheet, 7, 2), double.class), 1E-308);
			assertEquals("liEj double ő", new BigInteger("179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"), ExcelUtils.getCellValue(getCell(sheet, 8, 2)));
			assertEquals("liEj i0j", (double)123.00, ExcelUtils.getCellValue(getCell(sheet, 9, 2), double.class), 0.01);

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	@Test
	public void testDataFormat_NoSpecifiedClass() throws ExcelPOJOException, IOException {
		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/upload/ParserTest.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("eZ^Cv");

			assertEquals("eZ^Cv 01", new Integer(1), ExcelUtils.getCellValue(getCell(sheet, 1, 2)));
			assertEquals("eZ^Cv 02", "", ExcelUtils.getCellValue(getCell(sheet, 2, 2)));
			assertEquals("eZ^Cv 03", new Integer(-1234), ExcelUtils.getCellValue(getCell(sheet, 3, 2)));
			assertEquals("eZ^Cv 04", new Integer(-1234), ExcelUtils.getCellValue(getCell(sheet, 4, 2)));
			assertEquals("eZ^Cv 05", new Integer(-1234), ExcelUtils.getCellValue(getCell(sheet, 5, 2)));
			assertEquals("eZ^Cv 06", new Integer(-1234), ExcelUtils.getCellValue(getCell(sheet, 6, 2)));
			assertEquals("eZ^Cv 07", new Integer(-1234), ExcelUtils.getCellValue(getCell(sheet, 7, 2)));
			assertEquals("eZ^Cv 08", new Integer(-1234), ExcelUtils.getCellValue(getCell(sheet, 8, 2)));
			assertEquals("eZ^Cv 09", new Integer(-1234), ExcelUtils.getCellValue(getCell(sheet, 9, 2)));
			assertEquals("eZ^Cv 10", -1234.56, (Double)ExcelUtils.getCellValue(getCell(sheet, 10, 2)), 0.000000000000001);
			assertEquals("eZ^Cv 11", -1234.56, (Double)ExcelUtils.getCellValue(getCell(sheet, 11, 2)), 0.000000000000001);
			assertEquals("eZ^Cv 12", -1234.56, (Double)ExcelUtils.getCellValue(getCell(sheet, 12, 2)), 0.000000000000001);
			assertEquals("eZ^Cv 13", -1234.56, (Double)ExcelUtils.getCellValue(getCell(sheet, 13, 2)), 0.000000000000001);
			assertEquals("eZ^Cv 14", -1234.56, (Double)ExcelUtils.getCellValue(getCell(sheet, 14, 2)), 0.000000000000001);
			assertEquals("eZ^Cv 15", -1234.56, (Double)ExcelUtils.getCellValue(getCell(sheet, 15, 2)), 0.000000000000001);
			assertEquals("eZ^Cv 16", -1234.56, (Double)ExcelUtils.getCellValue(getCell(sheet, 16, 2)), 0.000000000000001);
			assertEquals("eZ^Cv 17", new Integer(-123456), ExcelUtils.getCellValue(getCell(sheet, 17, 2)));
			assertEquals("eZ^Cv 18", new Integer(-123456), ExcelUtils.getCellValue(getCell(sheet, 18, 2)));
			assertEquals("eZ^Cv 19", new Integer(-123456), ExcelUtils.getCellValue(getCell(sheet, 19, 2)));
			assertEquals("eZ^Cv 20", new Integer(-123456), ExcelUtils.getCellValue(getCell(sheet, 20, 2)));
			assertEquals("eZ^Cv 21", new Integer(-123456), ExcelUtils.getCellValue(getCell(sheet, 21, 2)));
			assertEquals("eZ^Cv 22", -123456.78, (Double)ExcelUtils.getCellValue(getCell(sheet, 22, 2)), 0.000000000000001);
			assertEquals("eZ^Cv 23", -123456.78, (Double)ExcelUtils.getCellValue(getCell(sheet, 23, 2)), 0.000000000000001);
			assertEquals("eZ^Cv 24", -123456.78, (Double)ExcelUtils.getCellValue(getCell(sheet, 24, 2)), 0.000000000000001);
			assertEquals("eZ^Cv 25", -123456.78, (Double)ExcelUtils.getCellValue(getCell(sheet, 25, 2)), 0.000000000000001);
			assertEquals("eZ^Cv 26", -123456.78, (Double)ExcelUtils.getCellValue(getCell(sheet, 26, 2)), 0.000000000000001);
			assertEquals("eZ^Cv 27", new Integer(-123456), ExcelUtils.getCellValue(getCell(sheet, 27, 2)));
			assertEquals("eZ^Cv 28", new Integer(-123456), ExcelUtils.getCellValue(getCell(sheet, 28, 2)));
			assertEquals("eZ^Cv 29", -123456.78, (Double)ExcelUtils.getCellValue(getCell(sheet, 29, 2)), 0.000000000000001);
			assertEquals("eZ^Cv 30", -123456.78, (Double)ExcelUtils.getCellValue(getCell(sheet, 30, 2)), 0.000000000000001);
			assertEquals("eZ^Cv 31", 0.1234, (Double)ExcelUtils.getCellValue(getCell(sheet, 31, 2)), 0.000000000000001);
			assertEquals("eZ^Cv 32", 0.1234, (Double)ExcelUtils.getCellValue(getCell(sheet, 32, 2)), 0.000000000000001);
			assertEquals("eZ^Cv 33", new Integer(2), ExcelUtils.getCellValue(getCell(sheet, 33, 2)));
			assertEquals("eZ^Cv 34","_t", ExcelUtils.getCellValue(getCell(sheet, 34, 2)));
			assertEquals("eZ^Cv 35", new Integer(-1234), ExcelUtils.getCellValue(getCell(sheet, 35, 2)));
			assertEquals("eZ^Cv 36",(new GregorianCalendar(2010, 6 -1, 23)).getTime(), ExcelUtils.getCellValue(getCell(sheet, 36, 2)));
			assertEquals("eZ^Cv 37",new BigInteger("-12345678901234500000"), ExcelUtils.getCellValue(getCell(sheet, 37, 2)));
			assertEquals("eZ^Cv 38",-1.23456789012345E12, (Double)ExcelUtils.getCellValue(getCell(sheet, 38, 2)), 0.000000000000001);

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	@Test
	public void testNUmeric_NoSpecifiedClass() throws ExcelPOJOException, IOException {
		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/upload/ParserTest.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("liEj");

			assertEquals("liEj Integer.MIN_VALUE", 2147483647, ExcelUtils.getCellValue(getCell(sheet, 1, 2)));
			assertEquals("liEj Integer.MAXV_ALUE", -2147483648 , ExcelUtils.getCellValue(getCell(sheet, 2, 2)));
			assertEquals("liEj Integer.MIN_VALUE +1", new BigInteger("2147483648"), ExcelUtils.getCellValue(getCell(sheet, 3, 2)));
			assertEquals("liEj Integer.MAXV_ALUE -1", new BigInteger("-2147483649"), ExcelUtils.getCellValue(getCell(sheet, 4, 2)));
			assertEquals("liEj ", 123.45, (Double)ExcelUtils.getCellValue(getCell(sheet, 5, 2)), 0.000000000000001);
			assertEquals("liEj double ", 1.23456789012345, (Double)ExcelUtils.getCellValue(getCell(sheet, 6, 2)), 0.000000000000001);
			assertEquals("liEj double ŏ", 2.2250738585072014E-308, (Double)ExcelUtils.getCellValue(getCell(sheet, 7, 2)), 1E-308);
			assertEquals("liEj double ő", new BigInteger("179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"), ExcelUtils.getCellValue(getCell(sheet, 8, 2)));
			assertEquals("liEj i0j", 123, ExcelUtils.getCellValue(getCell(sheet, 9, 2)));

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	@Test
	public void testDateFormat() throws ExcelPOJOException, IOException {
		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/upload/ParserTest.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("ttH[}bg");

			assertEquals("ttH[}bg 01", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 1, 2), Date.class));
			assertEquals("ttH[}bg 02", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 2, 2), Date.class));
			assertEquals("ttH[}bg 03", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 3, 2), Date.class));
			assertEquals("ttH[}bg 04", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 4, 2), Date.class));
			assertEquals("ttH[}bg 05", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 5, 2), Date.class));
			assertEquals("ttH[}bg 06", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 6, 2), Date.class));
			assertEquals("ttH[}bg 07", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 7, 2), Date.class));
			assertEquals("ttH[}bg 08", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 8, 2), Date.class));
			assertEquals("ttH[}bg 09", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 9, 2), Date.class));
			assertEquals("ttH[}bg 10", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 10, 2), Date.class));
			assertEquals("ttH[}bg 11", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 11, 2), Date.class));
			assertEquals("ttH[}bg 12", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 12, 2), Date.class));
			assertEquals("ttH[}bg 13", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 13, 2), Date.class));
			assertEquals("ttH[}bg 14", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 14, 2), Date.class));
			assertEquals("ttH[}bg 15", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 15, 2), Date.class));
			assertEquals("ttH[}bg 16", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 16, 2), Date.class));
			assertEquals("ttH[}bg 17", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 17, 2), Date.class));
			assertEquals("ttH[}bg 18", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 18, 2), Date.class));
			assertEquals("ttH[}bg 19", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 19, 2), Date.class));
			assertEquals("ttH[}bg 20", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 20, 2), Date.class));
			assertEquals("ttH[}bg 21", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 21, 2), Date.class));
//			assertEquals("ttH[}bg 22", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 22, 2), Date.class));
//			assertEquals("ttH[}bg 23", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 23, 2), Date.class));
//			assertEquals("ttH[}bg 24", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 24, 2), Date.class));
//			assertEquals("ttH[}bg 25", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 25, 2), Date.class));
//			assertEquals("ttH[}bg 26", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 26, 2), Date.class));
			assertEquals("ttH[}bg 27", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 27, 2), Date.class));
			assertEquals("ttH[}bg 28", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 28, 2), Date.class));
			assertEquals("ttH[}bg 29", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 29, 2), Date.class));
			assertEquals("ttH[}bg 30", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 30, 2), Date.class));
			assertEquals("ttH[}bg 31", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 31, 2), Date.class));
			assertEquals("ttH[}bg 32", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 32, 2), Date.class));
			assertEquals("ttH[}bg 33", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 33, 2), Date.class));
			assertEquals("ttH[}bg 34", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 34, 2), Date.class));
			assertEquals("ttH[}bg 35", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 35, 2), Date.class));
			assertEquals("ttH[}bg 36", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 36, 2), Date.class));
			assertEquals("ttH[}bg 37", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 37, 2), Date.class));
//			assertEquals("ttH[}bg 38", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 38, 2), Date.class));
			assertEquals("ttH[}bg 39", (new GregorianCalendar(2010, 1 -1, 2, 9, 3, 4)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 39, 2), Date.class));
			assertEquals("ttH[}bg 40", (new GregorianCalendar(2010, 6 -1, 18)).getTime(),ExcelUtils.getCellValue(getCell(sheet, 40, 2), Date.class));

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}

	}

	@Test(expected=TypeMismatchException.class)
	public void testDateFormatException22() throws IOException {
		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/upload/ParserTest.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("ttH[}bg");

			ExcelUtils.getCellValue(getCell(sheet, 22, 2), Date.class);
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}

	}
	@Test(expected=TypeMismatchException.class)
	public void testDateFormatException23() throws IOException {
		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/upload/ParserTest.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("ttH[}bg");

			ExcelUtils.getCellValue(getCell(sheet, 23, 2), Date.class);
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}

	}
	@Test(expected=TypeMismatchException.class)
	public void testDateFormatException24() throws IOException {
		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/upload/ParserTest.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("ttH[}bg");

			ExcelUtils.getCellValue(getCell(sheet, 24, 2), Date.class);
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}

	}

	@Test(expected=TypeMismatchException.class)
	public void testDateFormatException25() throws IOException {
		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/upload/ParserTest.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("ttH[}bg");

			ExcelUtils.getCellValue(getCell(sheet, 25, 2), Date.class);
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}

	}
	@Test(expected=TypeMismatchException.class)
	public void testDateFormatException26() throws IOException {
		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/upload/ParserTest.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("ttH[}bg");

			ExcelUtils.getCellValue(getCell(sheet, 26, 2), Date.class);
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}

	}

	@Test(expected=TypeMismatchException.class)
	public void testDateFormatException38() throws IOException {
		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/upload/ParserTest.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("ttH[}bg");

			ExcelUtils.getCellValue(getCell(sheet, 38, 2), Date.class);
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}

	}

	@Test
	public void testDateFormatConvertString() throws ExcelPOJOException, IOException {
		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/upload/ParserTest.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("ttH[}bg");

			assertEquals("ttH[}bg 01", "2010/1/2",ExcelUtils.getCellValue(getCell(sheet, 1, 2), String.class));
			assertEquals("ttH[}bg 02", "2-Jan-10",ExcelUtils.getCellValue(getCell(sheet, 2, 2), String.class));
			assertEquals("ttH[}bg 03", "2-Jan",ExcelUtils.getCellValue(getCell(sheet, 3, 2), String.class));
			assertEquals("ttH[}bg 04", "Jan-10",ExcelUtils.getCellValue(getCell(sheet, 4, 2), String.class));
			assertEquals("ttH[}bg 05", "9:03 AM",ExcelUtils.getCellValue(getCell(sheet, 5, 2), String.class));
			assertEquals("ttH[}bg 06", "9:03:04 AM",ExcelUtils.getCellValue(getCell(sheet, 6, 2), String.class));
			assertEquals("ttH[}bg 07", "9:03",ExcelUtils.getCellValue(getCell(sheet, 7, 2), String.class));
			assertEquals("ttH[}bg 08", "9:03:04",ExcelUtils.getCellValue(getCell(sheet, 8, 2), String.class));
			assertEquals("ttH[}bg 09", "2010/1/2 9:03",ExcelUtils.getCellValue(getCell(sheet, 9, 2), String.class));
			assertEquals("ttH[}bg 10", "1/2/10",ExcelUtils.getCellValue(getCell(sheet, 10, 2), String.class));
			assertEquals("ttH[}bg 11", "2010N12",ExcelUtils.getCellValue(getCell(sheet, 11, 2), String.class));
			assertEquals("ttH[}bg 12", "903",ExcelUtils.getCellValue(getCell(sheet, 12, 2), String.class));
			assertEquals("ttH[}bg 13", "90304b",ExcelUtils.getCellValue(getCell(sheet, 13, 2), String.class));
			assertEquals("ttH[}bg 14", "03:04",ExcelUtils.getCellValue(getCell(sheet, 14, 2), String.class));
			assertEquals("ttH[}bg 15", "03:04.0",ExcelUtils.getCellValue(getCell(sheet, 15, 2), String.class));
			assertEquals("ttH[}bg 16", "2010N1",ExcelUtils.getCellValue(getCell(sheet, 16, 2), String.class));
			assertEquals("ttH[}bg 17", "12",ExcelUtils.getCellValue(getCell(sheet, 17, 2), String.class));
			assertEquals("ttH[}bg 18", "H22.1.2",ExcelUtils.getCellValue(getCell(sheet, 18, 2), String.class));
			assertEquals("ttH[}bg 19", "22N12",ExcelUtils.getCellValue(getCell(sheet, 19, 2), String.class));
			assertEquals("ttH[}bg 20", "2010/01/02",ExcelUtils.getCellValue(getCell(sheet, 20, 2), String.class));
			assertEquals("ttH[}bg 21", "2010/01/02",ExcelUtils.getCellValue(getCell(sheet, 21, 2), String.class));

			assertEquals("ttH[}bg 22", "40180.37712962963",ExcelUtils.getCellValue(getCell(sheet, 22, 2), String.class));
			assertEquals("ttH[}bg 23", "40180.37712962963",ExcelUtils.getCellValue(getCell(sheet, 23, 2), String.class));
			assertEquals("ttH[}bg 24", "40180.37712962963",ExcelUtils.getCellValue(getCell(sheet, 24, 2), String.class));
			assertEquals("ttH[}bg 25", "40180.37712962963",ExcelUtils.getCellValue(getCell(sheet, 25, 2), String.class));
			assertEquals("ttH[}bg 26", "40180.37712962963",ExcelUtils.getCellValue(getCell(sheet, 26, 2), String.class));

			assertEquals("ttH[}bg 27", "2010/01/02",ExcelUtils.getCellValue(getCell(sheet, 27, 2), String.class));
			assertEquals("ttH[}bg 28", "2010/01/02",ExcelUtils.getCellValue(getCell(sheet, 28, 2), String.class));
			assertEquals("ttH[}bg 29", "2010/01/02",ExcelUtils.getCellValue(getCell(sheet, 29, 2), String.class));
			assertEquals("ttH[}bg 30", "2010/01/02",ExcelUtils.getCellValue(getCell(sheet, 30, 2), String.class));
			assertEquals("ttH[}bg 31", "2010/01/02",ExcelUtils.getCellValue(getCell(sheet, 31, 2), String.class));
			assertEquals("ttH[}bg 32", "2010/01/02",ExcelUtils.getCellValue(getCell(sheet, 32, 2), String.class));
			assertEquals("ttH[}bg 33", "2010/01/02",ExcelUtils.getCellValue(getCell(sheet, 33, 2), String.class));
			assertEquals("ttH[}bg 34", "2010/01/02",ExcelUtils.getCellValue(getCell(sheet, 34, 2), String.class));
			assertEquals("ttH[}bg 35", "2010/01/02",ExcelUtils.getCellValue(getCell(sheet, 35, 2), String.class));
			assertEquals("ttH[}bg 36", "2010/01/02",ExcelUtils.getCellValue(getCell(sheet, 36, 2), String.class));
			assertEquals("ttH[}bg 37", "2010/01/02",ExcelUtils.getCellValue(getCell(sheet, 37, 2), String.class));

			assertEquals("ttH[}bg 38", "40180.37712962963",ExcelUtils.getCellValue(getCell(sheet, 38, 2), String.class));

			assertEquals("ttH[}bg 39", "2010/01/02",ExcelUtils.getCellValue(getCell(sheet, 39, 2), String.class));
			assertEquals("ttH[}bg 40", "2010/06/18",ExcelUtils.getCellValue(getCell(sheet, 40, 2), String.class));

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}

	}

}
